# Media Analytics for Matomo

## Description

Hi, this is Tom from Matomo, the creators of the web analytics platform which is used by over 1.4 million websites and apps in over 190 countries.

Over the past years we have spent a fortune and lots of our time on producing video and audio content for our websites 
and apps. But are they being watched? For how long? By whom? From where are they watching it? How do they affect our 
conversion rates and sales? Is it better when we place that video somewhere else or replace it with another one? 
Would another video perform better? When we added subtitles, did it change something? How are our video marketing campaigns doing? Can we justify the cost and time for producing them? If you have similar questions and unknowns, then we have built just the right tool for you.

> [Media Analytics](https://www.media-analytics.net) tracks your videos and audio and gives you ultimate insights into media usage and how that usage is connected to all your other metrics like conversions, sales, page views and more. 

We have put a lot of love in building Media Analytics and added so many advanced features it has really given us another view on our media content and we are sure it can do the same for you when you have it.

Media Analytics is super simple to install and works in most cases just like that out of the box. 
It is so well integrated into Matomo you will be surprised. It has all of those features like getting real time 
insights, filtering reports to a particular user segment, the audience log shows you every step your audience 
did and the audience map shows you from where your media is being watched either in real time or in the past.
On top there are so many other reports, widgets, APIs and more giving you all the information you need to know and you can 
share all of them with your colleagues and customers.

> If you are spending money or time on your media like we do, we are sure it will give you plenty of insights and maybe change the way you think about your current media.

### Benefits

* Learn all about the performance of your videos & audios to make better decisions for your business or organization.
* Understand who has watched your media, how much of each media they have watched, which parts they have watched, and which medias are contributing the most value to your business or organization.
* Discover which effect your media has on your overall traffic, revenue and conversions, and get a 360 degree view on your users.
* Test different videos, audios, media players, ... and find out which ones are more successful.
* Get answers to lots of questions like "Are my videos seen till the end?".
* Share video and audio metrics with your colleagues and partners for greater transparency.
* Get the pulse on your video and audio analytics and be able to make quick decisions with lots of real time media reports.
* View individual viewers and how they watched and interacted with your videos and audios.
* Gives you an overall media overview, but also detailed reports about how each media was watched.
* Segment any Matomo report by your audience to gain new insights on different personas.
* Simple to no [setup](https://developer.matomo.org/guides/media-analytics/setup).
* Supports streams.
* and many more!

### Our promise 
<a href="https://shop.matomo.org/free-trial/" target="_blank"><img src="https://plugins.matomo.org/img/free_trial_image.png" style="width:220px;float:right;margin-bottom: 10px;" alt="Our promise to you"></a>Our Media Analytics is built on top of Matomo which means you get all those benefits and features from Matomo as well. Like data ownership, no data limits, being able to host it yourself on premise and use it in the intranet etc. That’s why Matomo is so popular among businesses, corporations and governments. Hand-crafted by the makers of Matomo, we are convinced once you start looking into your video & audio insights, you will love it. 

> This is why we give you a [free 30 day trial](https://shop.matomo.org/free-trial/). We will remind you about the subscription seven days before the end of the trial. There are no strings attached.

So try it now and let us know how you do. We are happy to help you get started and to hear how it changes your view on your media.

### Perfectly integrated and supported

We are the creators of Matomo and know it better than anyone else. This means all plugins are perfectly integrated into Matomo and come with outstanding features and quality to grow your business. We help our clients get started, configure, monitor and make the most of their Matomo analytics service. We also offer unique analytics products and services that help grow your business and meet the needs of medium and large businesses alike.

### Reporting features
Adds more than 15 new widgets and reports that all can be added to the dashboard or exported as widget. Some of the reports include:

* Media usage by media title.
* Media usage by media resource URL and grouped resource URL.
* Media usage by hour.
* Video usage by video resolution.
* Media usage by media player.
* Drill down to get usage for any specific video or audio.
* View a heatmap of which parts of a video or audio have been viewed.

Some of the metrics displayed include

* Number of impressions (how often was a media shown but not played).
* Number of plays (how often was a media actually played after it was shown).
* Number of finishes (how often was a media finished).
* Time spent watching or listening to a media.
* Media duration / length.
* Time to play (how long did visitors wait before they start playing a media).
* Nunber of views in fullscreen.
* And many more.

Evolution graphs show how the media consumption on your website or app changes over time.

 
### Real-time features
* View the [audience log](https://matomo.org/docs/media-analytics/#audience-log) to learn how each individual visitor used your website before and after playing a media.
* View the [audience map](https://matomo.org/docs/media-analytics/#audience-map) to see at a glance where your visitors are from (lets you go down from continent to cities).

### Segmenting features
* Many new segments are provided. Segment your visitors by Media Title, Media URL, time spent playing media, the number of media plays and many more.
* Combine these Media segments with any other Matomo segments to drill down and get deep insights into your audience.

### Tracking features
* Tracks events when you a user plays, pauses, resumes, seeks, or finishes a video and see at what position within the media they paused or resumed. They can be viewed in the [Visitor Log](https://matomo.org/docs/user-profile/).
* Currently supports HTML5 Audio & Video, SoundManager 2, JW Player (Flash and HTML5), Flowplayer, Video.js, MediaElement.js, SoundCloud, YouTube and Vimeo out of the box.
* Possibility to track the usage of any player by defining a [custom player](https://developer.matomo.org/guides/media-analytics/custom-player).
* Lets you exclude specific videos from being tracked.
* Lets you optionally [customize the tracked media title and resource URL](https://developer.matomo.org/guides/media-analytics/options).
* Works with multiple Matomo tracker instances
* Small footprint. Only adds a very few kilobytes to your Matomo JavaScript tracker (`piwik.js`). 

### Privacy features
* Supports Matomo's [privacy](https://matomo.org/docs/privacy/) and GDPR features like the right to erase data or the right to export data. GDPR stands for General Data Protection Regulation and is for example also known as RGPD in French, DS-GVO in German
* The plugin does not store personal data

### Export & API features 
* Get your Video and Audio analytics reports by [email](https://matomo.org/docs/email-reports/) to you, your colleagues or customers. 
* Via the [HTTP Tracking API](https://developer.matomo.org/api-reference/tracking-api), media can be tracked on any platform or application (such as iOS or Android).
* All reports including real time reports are available via the [Media Analytics HTTP Reporting API](https://developer.matomo.org/api-reference/reporting-api#MediaAnalytics), and support [Matomo segments](https://matomo.org/docs/segmentation/).
* Export any video and audio analytics report directly in your app, dashboard, or even TV screen! Even your real time reports can be [embedded](https://matomo.org/docs/embed-piwik-report/) anywhere. 

### Custom media players

If you need help implementing Media Analytics for your custom media player please [contact us](https://matomo.org/support).
Alternatively we document how you can [track any custom media player](https://developer.matomo.org/guides/media-analytics/custom-player).

### Integrates with Matomo Analytics platform

* See where your users are from: which countries, regions and cities are most interested in viewing your video content, or listening to your audio?
* Create [custom alerts](https://plugins.matomo.org/CustomAlerts) and be notified when specific videos become popular, or when your overall video usage changes.
* Drill down deeper and filter viewers who have watched specific videos or audio content, who have spent more than N seconds watching videos, and much more, [with Segments](https://matomo.org/docs/segmentation/).
* View the evolution over time of any of your video or audio, and for any of the media metrics with [Row Evolution](https://matomo.org/docs/row-evolution/).
* View individual viewers and how they watched and interacted with your videos (in [Real time!](https://matomo.org/docs/real-time/)) with the Audience log, the [User Profile](https://matomo.org/docs/user-profile/) and the Visitor Log.
* View your media analytics reports on the [Matomo Mobile App](https://matomo.org/mobile/).
* Create Goals for specific videos or audio to measure in even more details how your viewers interact over time with a particular media.
* Track unlimited number of videos, viewers, and interactions. [No data limit](https://matomo.org/docs/data-limits/).
* Supports [Custom Reports](https://plugins.matomo.org/CustomReports).

### More information

To learn more about the plugin have a look at the [Media Analytics website](https://www.media-analytics.net), 
[Media Analytics User Guide](https://matomo.org/docs/media-analytics/), 
[Media Analytics FAQ](https://matomo.org/faq/media-analytics/) and 
the [Developer documentation](https://developer.matomo.org/guides/media-analytics).

This plugin is built and maintained by the creators of Matomo.
