<?php

header('Content-Type: text/calendar; charset=utf-8');
header('Content-Disposition: attachment; filename="'.$_GET['title'].'.ics"');

require_once('vendor/autoload.php');

$vCalendar = new \Eluceo\iCal\Component\Calendar('Work');

$vEvent = new \Eluceo\iCal\Component\Event();
$vAlarm = new \Eluceo\iCal\Component\Alarm;

$title = $_GET['title'];
$description = $_GET['desciption'];

$startDate = new \DateTime($_GET['start']);
$endDate = new \DateTime($_GET['end']);

$startDate->setTimezone(new DateTimeZone('Europe/London'));
$endDate->setTimezone(new DateTimeZone('Europe/London'));


$vEvent
    ->setDtStart($startDate)
    ->setDtEnd($endDate)
    ->setNoTime(false)
    ->setSummary($title)
    ->setDescription($description);


$vAlarm->setAction(\Eluceo\iCal\Component\Alarm::ACTION_DISPLAY);
$vAlarm->setDescription($description);
$vAlarm->setTrigger('PT0S', true);

$vEvent->addComponent($vAlarm);

$vCalendar->addComponent($vEvent);

echo $vCalendar->render();