<?php
// ajax_handler.php

header('Content-Type: application/json');

function getClaudeApiKey() {
    $keyFile = __DIR__ . '/claudeapikey.txt';
    if (file_exists($keyFile)) {
        return trim(file_get_contents($keyFile));
    }
    return null;
}

function callClaudeAPI($request, $fileContent) {
    $apiUrl = 'https://api.anthropic.com/v1/completions';
    $apiKey = getClaudeApiKey();

    if (!$apiKey) {
        return ['error' => 'API key not set. Please set your Claude API key.'];
    }

    $prompt = "Here's the current PHP code:\n\n```php\n$fileContent\n```\n\n" .
              "Based on this existing code, please provide only PHP code for the following request:\n\n$request\n\n" .
              "Respond with only the PHP code, no explanations or markdown formatting.";

    $data = [
        'model' => 'claude-2',
        'prompt' => $prompt,
        'max_tokens_to_sample' => 1000,
        'temperature' => 0.7,
    ];

    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-API-Key: ' . $apiKey,
        'anthropic-version: 2023-06-01'
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    // Enable verbose output for debugging
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Get verbose information
    rewind($verbose);
    $verboseLog = stream_get_contents($verbose);

    curl_close($ch);

    $result = json_decode($response, true);

    if ($httpCode != 200) {
        return [
            'error' => 'API request failed: ' . ($result['error']['message'] ?? 'Unknown error'),
            'http_code' => $httpCode,
            'response' => $response,
            'verbose_log' => $verboseLog,
            'request_data' => $data,
            'api_url' => $apiUrl
        ];
    }

    return $result;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'request_code') {
    $aiRequest = $_POST['ai_request'] ?? '';
    $fileContent = $_POST['file_content'] ?? '';
    $projectName = $_POST['project_name'] ?? '';

    $aiResponse = callClaudeAPI($aiRequest, $fileContent);

    if (isset($aiResponse['error'])) {
        echo json_encode([
            'error' => $aiResponse['error'],
            'details' => [
                'http_code' => $aiResponse['http_code'] ?? null,
                'response' => $aiResponse['response'] ?? null,
                'verbose_log' => $aiResponse['verbose_log'] ?? null,
                'request_data' => $aiResponse['request_data'] ?? null,
                'api_url' => $aiResponse['api_url'] ?? null
            ]
        ]);
    } else {
        $generatedCode = $aiResponse['completion'] ?? '';
        $newContent = $fileContent . "\n\n" . $generatedCode;
        echo json_encode(['code' => $newContent]);
    }
    exit;
}

echo json_encode(['error' => 'Invalid request']);