<?php
function listProjects() {
    $projects = array_filter(glob('*'), 'is_dir');
    echo '<ul>';
    foreach ($projects as $project) {
        echo '<li><a href="?edit=' . urlencode($project) . '">' . htmlspecialchars($project) . '</a></li>';
    }
    echo '</ul>';
}

function deleteProject($dir) {
    if (!is_dir($dir)) return;
    $files = array_diff(scandir($dir), ['.', '..']);
    foreach ($files as $file) {
        (is_dir("$dir/$file")) ? deleteProject("$dir/$file") : unlink("$dir/$file");
    }
    rmdir($dir);
}

function getClaudeApiKey() {
    $keyFile = __DIR__ . '/claudeapikey.txt';
    if (file_exists($keyFile)) {
        return trim(file_get_contents($keyFile));
    }
    return null;
}

function saveClaudeApiKey($key) {
    $keyFile = __DIR__ . '/claudeapikey.txt';
    $result = file_put_contents($keyFile, trim($key));
    if ($result === false) {
        return "Failed to save API key. Check file permissions.";
    }
    return "API key saved successfully.";
}

function callClaudeAPI($request, $fileContent) {
    $apiUrl = 'https://api.anthropic.com/v1/completions';
    $apiKey = getClaudeApiKey();

    if (!$apiKey) {
        return ['error' => 'API key not set. Please set your Claude API key.'];
    }

    $prompt = "Here's the current PHP code:\n\n```php\n$fileContent\n```\n\n" .
              "Based on this existing code, please provide only PHP code for the following request:\n\n$request\n\n" .
              "Respond with only the PHP code, no explanations or markdown formatting.";

    $data = [
        'model' => 'claude-2',
        'prompt' => $prompt,
        'max_tokens_to_sample' => 1000,
        'temperature' => 0.7,
    ];

    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-API-Key: ' . $apiKey,
        'anthropic-version: 2023-06-01'
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    // Enable verbose output for debugging
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Get verbose information
    rewind($verbose);
    $verboseLog = stream_get_contents($verbose);

    curl_close($ch);

    $result = json_decode($response, true);

    if ($httpCode != 200) {
        return [
            'error' => 'API request failed: ' . ($result['error']['message'] ?? 'Unknown error'),
            'http_code' => $httpCode,
            'response' => $response,
            'verbose_log' => $verboseLog
        ];
    }

    return $result;
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['set_api_key'])) {
        $message = saveClaudeApiKey($_POST['claude_api_key']);
    }

    if (isset($_POST['delete_project'])) {
        $projectName = $_POST['project_name'];
        $projectDir = __DIR__ . '/' . $projectName;
        deleteProject($projectDir);
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }

    if (isset($_POST['project_name'])) {
        $projectName = trim($_POST['project_name']);
        $projectDir = __DIR__ . '/' . $projectName;

        if (!file_exists($projectDir)) {
            mkdir($projectDir, 0777, true);
            file_put_contents($projectDir . '/index.php', "<?php\n// Your code here\n");
        }

        if (isset($_POST['file_content'])) {
            file_put_contents($projectDir . '/index.php', $_POST['file_content']);
        }

        if (isset($_POST['ai_request'])) {
            $aiRequest = $_POST['ai_request'];
            $fileContent = file_get_contents($projectDir . '/index.php');
            $aiResponse = callClaudeAPI($aiRequest, $fileContent);
            if (isset($aiResponse['error'])) {
                $message = '<h3>Error occurred:</h3>';
                $message .= '<pre>' . htmlspecialchars(print_r($aiResponse, true)) . '</pre>';
            } else {
                $message = '<h3>Generated PHP Code:</h3>';
                $generatedCode = isset($aiResponse['completion']) ? $aiResponse['completion'] : 'No code generated.';
                $message .= '<pre><code class="language-php">' . htmlspecialchars($generatedCode) . '</code></pre>';
                
                // Add a form to allow the user to append or replace the code
                $message .= '<form method="post">';
                $message .= '<input type="hidden" name="generated_code" value="' . htmlspecialchars($generatedCode) . '">';
                $message .= '<input type="hidden" name="project_name" value="' . htmlspecialchars($projectName) . '">';
                $message .= '<input type="submit" name="append_code" value="Append Code">';
                $message .= '<input type="submit" name="replace_code" value="Replace Code">';
                $message .= '</form>';
            }
        }

        // Handle appending or replacing the generated code
        if (isset($_POST['append_code']) || isset($_POST['replace_code'])) {
            $generatedCode = $_POST['generated_code'];
            $currentContent = file_get_contents($projectDir . '/index.php');
            
            if (isset($_POST['append_code'])) {
                $newContent = $currentContent . "\n" . $generatedCode;
            } else {
                $newContent = $generatedCode;
            }
            
            file_put_contents($projectDir . '/index.php', $newContent);
            $message = 'Code has been ' . (isset($_POST['append_code']) ? 'appended' : 'replaced') . ' successfully.';
            $fileContent = $newContent; // Update the file content for display
        }

        echo '<!DOCTYPE html>';
        echo '<html lang="en">';
        echo '<head>';
        echo '<meta charset="UTF-8">';
        echo '<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">';
        echo '<title>Edit Project</title>';
        echo '<style>';
        echo 'body { font-family: Arial, sans-serif; margin: 20px; }';
        echo 'form { margin-bottom: 20px; }';
        echo 'textarea { width: 100%; max-width: 600px; }';
        echo 'input[type="text"], input[type="submit"] { padding: 10px; margin-top: 10px; }';
        echo 'input[type="submit"] { cursor: pointer; }';
        echo 'ul { list-style-type: none; padding: 0; }';
        echo 'li { margin: 5px 0; }';
        echo 'a { text-decoration: none; color: #007BFF; }';
        echo 'a:hover { text-decoration: underline; }';
        echo '</style>';
        echo '</head>';
        echo '<body>';
        echo '<form method="post">';
        echo '<textarea name="file_content" rows="10" cols="50">' . htmlspecialchars($fileContent) . '</textarea><br>';
        echo '<input type="hidden" name="project_name" value="' . htmlspecialchars($projectName) . '">';
        echo '<input type="submit" value="Save">';
        echo '</form>';
        echo '<form method="post" style="margin-top: 10px;">';
        echo '<input type="hidden" name="project_name" value="' . htmlspecialchars($projectName) . '">';
        echo '<input type="submit" name="delete_project" value="Delete Project" onclick="return confirm(\'Are you sure you want to delete this project?\');">';
        echo '</form>';
        echo '<a href="' . $projectName . '/index.php" target="_blank">Run ' . htmlspecialchars($projectName) . '</a>';
        echo '<h3>Ask Claude AI to Generate Code</h3>';
        echo '<textarea id="ai_request" rows="5" cols="50" placeholder="Describe what you want to generate..."></textarea><br>';
        echo '<button id="request_code">Request Code</button>';
        echo '<script>
document.getElementById("request_code").addEventListener("click", function() {
    var aiRequest = document.getElementById("ai_request").value;
    var fileContent = document.querySelector("textarea[name=\'file_content\']").value;
    var projectName = "' . htmlspecialchars($projectName) . '";
    
    fetch("ajax_handler.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
        },
        body: "action=request_code&ai_request=" + encodeURIComponent(aiRequest) + "&file_content=" + encodeURIComponent(fileContent) + "&project_name=" + encodeURIComponent(projectName)
    })
    .then(response => response.json())
    .then(data => {
        if (data.error) {
            alert("Error: " + data.error);
        } else {
            document.querySelector("textarea[name=\'file_content\']").value = data.code;
        }
    })
    .catch((error) => {
        console.error("Error:", error);
        alert("An error occurred while requesting code.");
    });
});
</script>';
        echo '</body>';
        echo '</html>';
    }
} else if (isset($_GET['edit'])) {
    $projectName = $_GET['edit'];
    $projectDir = __DIR__ . '/' . $projectName;

    if (file_exists($projectDir)) {
        $fileContent = file_get_contents($projectDir . '/index.php');
        echo '<!DOCTYPE html>';
        echo '<html lang="en">';
        echo '<head>';
        echo '<meta charset="UTF-8">';
        echo '<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">';
        echo '<title>Edit Project</title>';
        echo '<style>';
        echo 'body { font-family: Arial, sans-serif; margin: 20px; }';
        echo 'form { margin-bottom: 20px; }';
        echo 'textarea { width: 100%; max-width: 600px; }';
        echo 'input[type="text"], input[type="submit"] { padding: 10px; margin-top: 10px; }';
        echo 'input[type="submit"] { cursor: pointer; }';
        echo 'ul { list-style-type: none; padding: 0; }';
        echo 'li { margin: 5px 0; }';
        echo 'a { text-decoration: none; color: #007BFF; }';
        echo 'a:hover { text-decoration: underline; }';
        echo '</style>';
        echo '</head>';
        echo '<body>';
        echo '<form method="post">';
        echo '<textarea name="file_content" rows="10" cols="50">' . htmlspecialchars($fileContent) . '</textarea><br>';
        echo '<input type="hidden" name="project_name" value="' . htmlspecialchars($projectName) . '">';
        echo '<input type="submit" value="Save">';
        echo '</form>';
        echo '<form method="post" style="margin-top: 10px;">';
        echo '<input type="hidden" name="project_name" value="' . htmlspecialchars($projectName) . '">';
        echo '<input type="submit" name="delete_project" value="Delete Project" onclick="return confirm(\'Are you sure you want to delete this project?\');">';
        echo '</form>';
        echo '<a href="' . $projectName . '/index.php" target="_blank">Run ' . htmlspecialchars($projectName) . '</a>';
        echo '<h3>Ask Claude AI to Generate Code</h3>';
        echo '<textarea id="ai_request" rows="5" cols="50" placeholder="Describe what you want to generate..."></textarea><br>';
        echo '<button id="request_code">Request Code</button>';
        echo '<script>
document.getElementById("request_code").addEventListener("click", function() {
    var aiRequest = document.getElementById("ai_request").value;
    var fileContent = document.querySelector("textarea[name=\'file_content\']").value;
    var projectName = "' . htmlspecialchars($projectName) . '";
    
    fetch("ajax_handler.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
        },
        body: "action=request_code&ai_request=" + encodeURIComponent(aiRequest) + "&file_content=" + encodeURIComponent(fileContent) + "&project_name=" + encodeURIComponent(projectName)
    })
    .then(response => response.json())
    .then(data => {
        if (data.error) {
            alert("Error: " + data.error);
        } else {
            document.querySelector("textarea[name=\'file_content\']").value = data.code;
        }
    })
    .catch((error) => {
        console.error("Error:", error);
        alert("An error occurred while requesting code.");
    });
});
</script>';
        echo '</body>';
        echo '</html>';
    } else {
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }
} else {
    echo '<!DOCTYPE html>';
    echo '<html lang="en">';
    echo '<head>';
    echo '<meta charset="UTF-8">';
    echo '<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">';
    echo '<title>Create Project</title>';
    echo '<style>';
    echo 'body { font-family: Arial, sans-serif; margin: 20px; }';
    echo 'form { margin-bottom: 20px; }';
    echo 'input[type="text"], input[type="submit"] { padding: 10px; margin-top: 10px; }';
    echo 'input[type="submit"] { cursor: pointer; }';
    echo 'ul { list-style-type: none; padding: 0; }';
    echo 'li { margin: 5px 0; }';
    echo 'a { text-decoration: none; color: #007BFF; }';
    echo 'a:hover { text-decoration: underline; }';
    echo '</style>';
    echo '</head>';
    echo '<body>';
    echo '<form method="post">';
    echo 'Project Name: <input type="text" name="project_name" required><br>';
    echo '<input type="submit" value="Create Project">';
    echo '</form>';
    echo '<h2>Existing Projects</h2>';
    listProjects();
    echo '<h3>Set Claude API Key</h3>';
    echo '<form method="post">';
    echo 'API Key: <input type="text" name="claude_api_key" required><br>';
    echo '<input type="submit" name="set_api_key" value="Set API Key">';
    echo '</form>';
    echo '</body>';
    echo '</html>';
}
?>
