<?php
// Load bird data from JSON file
$birdsData = file_get_contents('birds.json');
$birds = json_decode($birdsData, true);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Western Cape Birds</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        #bird-list {
            list-style-type: none;
            padding: 0;
        }
        #bird-list li {
            cursor: pointer;
        }
        #bird-list li.seen {
            text-decoration: line-through;
            color: #999;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Western Cape Birds</h1>
        <div class="form-group">
            <input type="text" class="form-control" id="search" placeholder="Search birds...">
        </div>
        <ul class="list-group" id="bird-list"></ul>
    </div>

    <script>
        let birds = <?php echo json_encode($birds); ?>;
        let seenBirds = JSON.parse(localStorage.getItem('seenBirds')) || [];

        function renderBirds(filteredBirds) {
            const birdList = document.getElementById('bird-list');
            birdList.innerHTML = '';

            filteredBirds.forEach(bird => {
                const li = document.createElement('li');
                li.textContent = bird.name;
                li.classList.add('list-group-item');
                li.addEventListener('click', () => {
                    toggleBirdSeen(bird.id);
                });
                if (seenBirds.includes(bird.id)) {
                    li.classList.add('seen');
                }
                birdList.appendChild(li);
            });
        }

        function toggleBirdSeen(birdId) {
            const birdIndex = seenBirds.indexOf(birdId);
            if (birdIndex === -1) {
                seenBirds.push(birdId);
            } else {
                seenBirds.splice(birdIndex, 1);
            }
            localStorage.setItem('seenBirds', JSON.stringify(seenBirds));
            renderBirds(filterBirds());
        }

        function filterBirds() {
            const searchText = document.getElementById('search').value.trim().toLowerCase();
            return birds.filter(bird => bird.name.toLowerCase().includes(searchText));
        }

        document.getElementById('search').addEventListener('input', () => {
            renderBirds(filterBirds());
        });

        renderBirds(birds);
    </script>
</body>
</html>