
<?php
$file = 'todo.json';
if (!file_exists($file)) {
    file_put_contents($file, '[]');
}
$tasks = array();

if (file_exists($file)) {
    $tasks = json_decode(file_get_contents($file), true);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["add"])) {
        $task = $_POST["task"];
        $tasks[] = array("task" => $task);
        file_put_contents($file, json_encode($tasks));
    } elseif (isset($_POST["update"])) {
        $id = $_POST["id"];
        $task = $_POST["task"];
        $tasks[$id]["task"] = $task;
        file_put_contents($file, json_encode($tasks));
    } elseif (isset($_POST["delete"])) {
        $id = $_POST["id"];
        unset($tasks[$id]);
        $tasks = array_values($tasks);
        file_put_contents($file, json_encode($tasks));
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Todo App</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }

        h1 {
            text-align: center;
        }

        form {
            margin-bottom: 20px;
        }

        input[type="text"] {
            padding: 5px;
            width: 300px;
        }

        button {
            padding: 5px 10px;
        }

        ul {
            list-style-type: none;
            padding: 0;
        }

        li {
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <h1>Todo App</h1>
    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
        <input type="text" name="task" placeholder="Enter task" required>
        <button type="submit" name="add">Add Task</button>
    </form>

    <ul>
        <?php
        foreach ($tasks as $key => $value) {
            echo "<li>";
            echo $value["task"];
            echo "<form method='post' action='" . htmlspecialchars($_SERVER["PHP_SELF"]) . "' style='display: inline-block;'>";
            echo "<input type='hidden' name='id' value='" . $key . "'>";
            echo "<input type='text' name='task' value='" . $value["task"] . "' required>";
            echo "<button type='submit' name='update'>Update</button>";
            echo "<button type='submit' name='delete'>Delete</button>";
            echo "</form>";
            echo "</li>";
        }
        ?>
    </ul>

    <script>
        var forms = document.querySelectorAll('form');
        forms.forEach(function(form) {
            form.addEventListener('submit', function(event) {
                event.preventDefault();
                var formData = new FormData(form);
                var xhr = new XMLHttpRequest();
                xhr.open('POST', form.action, true);
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
                        location.reload();
                    }
                };
                xhr.send(formData);
            });
        });
    </script>
</body>
</html>
```