<?php
$projectsDir = 'projects/';
$projects = array_diff(scandir($projectsDir), array('..', '.'));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newProjectName = $_POST['new_project_name'];
    if (!empty($newProjectName)) {
        $newProjectPath = $projectsDir . $newProjectName;
        if (!file_exists($newProjectPath)) {
            mkdir($newProjectPath, 0777, true);
            $indexFile = $newProjectPath . '/index.php';
            file_put_contents($indexFile, '<?php echo "Hello, World!"; ?>');
            header('Location: edit.php?project=' . urlencode($newProjectName));
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Project List</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>
    <h1>Project List</h1>
    
    <ul>
        <?php foreach ($projects as $project): ?>
            <li>
                <a href="edit.php?project=<?php echo urlencode($project); ?>&page=index.php"><?php echo htmlspecialchars($project); ?></a>
            </li>
        <?php endforeach; ?>
    </ul>

    <h2>Create New Project</h2>
    <form method="POST" action="">
        <input type="text" name="new_project_name" placeholder="Enter project name">
        <button type="submit">Create Project</button>
    </form>

    <button onclick="addApiKey()">Add Claude AI API Key</button>

    <script>
    function addApiKey() {
        var apiKey = prompt("Please enter your Claude AI API Key:");
        if (apiKey != null && apiKey != "") {
            $.ajax({
                url: 'save_api_key.php',
                type: 'POST',
                data: JSON.stringify({ apiKey: apiKey }),
                contentType: 'application/json',
                success: function(response) {
                    alert('API Key saved successfully!');
                },
                error: function(xhr, status, error) {
                    alert('Error saving API Key: ' + error);
                }
            });
        }
    }
    </script>
</body>
</html>