<?php
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$apiKey = $input['apiKey'] ?? '';

if (empty($apiKey)) {
    http_response_code(400);
    echo json_encode(['error' => 'API Key is required']);
    exit;
}

$credentials = ['apiKey' => $apiKey];
$result = file_put_contents('credentials.json', json_encode($credentials));

if ($result === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to save API Key']);
} else {
    echo json_encode(['success' => true]);
}