<?php
// Fetch data from the endpoint
$json_data = file_get_contents('http://winder.nom.za/cide/projects/CSV%20to%20Json/?file_hash=ad3fb2f4ac0ebe38e5223f3cae288cd1');
$data = json_decode($json_data, true);

// Initialize DWTW data
$dwtw_data = [
    'Deposit' => 0,
    'Withdrawal' => 0,
    'Transfer' => 0,
    'Exchange' => 0
];

$monthly_dwtw = [];
$yearly_dwtw = [];

// Process data
foreach ($data as $transaction) {
    $date = date('Y-m', strtotime($transaction['Date']));
    $year = date('Y', strtotime($transaction['Date']));
    $amount = abs(floatval($transaction['Amount']));
    $type = $transaction['Type'];

    if (!isset($monthly_dwtw[$date])) {
        $monthly_dwtw[$date] = [
            'Deposit' => 0,
            'Withdrawal' => 0,
            'Transfer' => 0,
            'Exchange' => 0
        ];
    }

    if (!isset($yearly_dwtw[$year])) {
        $yearly_dwtw[$year] = [
            'Deposit' => 0,
            'Withdrawal' => 0,
            'Transfer' => 0,
            'Exchange' => 0
        ];
    }

    switch ($type) {
        case 'TOPUP':
            $dwtw_data['Deposit'] += $amount;
            $monthly_dwtw[$date]['Deposit'] += $amount;
            $yearly_dwtw[$year]['Deposit'] += $amount;
            break;
        case 'ATM':
        case 'CARD_PAYMENT':
            $dwtw_data['Withdrawal'] += $amount;
            $monthly_dwtw[$date]['Withdrawal'] += $amount;
            $yearly_dwtw[$year]['Withdrawal'] += $amount;
            break;
        case 'TRANSFER':
            $dwtw_data['Transfer'] += $amount;
            $monthly_dwtw[$date]['Transfer'] += $amount;
            $yearly_dwtw[$year]['Transfer'] += $amount;
            break;
        case 'EXCHANGE':
            $dwtw_data['Exchange'] += $amount;
            $monthly_dwtw[$date]['Exchange'] += $amount;
            $yearly_dwtw[$year]['Exchange'] += $amount;
            break;
    }
}

// Sort data
ksort($monthly_dwtw);
ksort($yearly_dwtw);

// Helper function to format currency
function format_currency($amount) {
    return '' . number_format($amount, 2);
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DWTW Financial Data Summary</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; }
        h1, h2 { color: #333; }
        table { border-collapse: collapse; width: 100%; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        tr:nth-child(even) { background-color: #f9f9f9; }
    </style>
</head>
<body>
    <h1>DWTW Financial Data Summary</h1>
    
    <h2>Overall DWTW Summary</h2>
    <table>
        <tr>
            <th>Category</th>
            <th>Total Amount</th>
        </tr>
        <?php foreach ($dwtw_data as $category => $amount): ?>
            <tr>
                <td><?php echo $category; ?></td>
                <td><?php echo format_currency($amount); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h2>Yearly DWTW Summary</h2>
    <table>
        <tr>
            <th>Year</th>
            <th>Deposit</th>
            <th>Withdrawal</th>
            <th>Transfer</th>
            <th>Exchange</th>
        </tr>
        <?php foreach ($yearly_dwtw as $year => $data): ?>
            <tr>
                <td><?php echo $year; ?></td>
                <td><?php echo format_currency($data['Deposit']); ?></td>
                <td><?php echo format_currency($data['Withdrawal']); ?></td>
                <td><?php echo format_currency($data['Transfer']); ?></td>
                <td><?php echo format_currency($data['Exchange']); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h2>Monthly DWTW Summary (Last 12 Months)</h2>
    <table>
        <tr>
            <th>Month</th>
            <th>Deposit</th>
            <th>Withdrawal</th>
            <th>Transfer</th>
            <th>Exchange</th>
        </tr>
        <?php 
        $last_12_months = array_slice($monthly_dwtw, -12, 12, true);
        foreach ($last_12_months as $month => $data): 
        ?>
            <tr>
                <td><?php echo $month; ?></td>
                <td><?php echo format_currency($data['Deposit']); ?></td>
                <td><?php echo format_currency($data['Withdrawal']); ?></td>
                <td><?php echo format_currency($data['Transfer']); ?></td>
                <td><?php echo format_currency($data['Exchange']); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
