
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Todo List App</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        
        h1 {
            text-align: center;
            color: #333;
        }
        
        input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 3px;
            box-sizing: border-box;
            margin-bottom: 10px;
        }
        
        ul {
            list-style-type: none;
            padding: 0;
        }
        
        li {
            padding: 10px;
            border-bottom: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        li span {
            flex-grow: 1;
        }
        
        li button {
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Todo List</h1>
        <input type="text" id="newTodo" placeholder="Enter a new todo...">
        <ul id="todoList"></ul>
    </div>

    <script>
        const todoList = document.getElementById('todoList');
        const newTodoInput = document.getElementById('newTodo');
        let todos = [];

        // Render todos
        function renderTodos() {
            todoList.innerHTML = '';
            todos.forEach((todo, index) => {
                const li = document.createElement('li');
                const span = document.createElement('span');
                span.textContent = todo;
                li.appendChild(span);

                const editButton = document.createElement('button');
                editButton.textContent = 'Edit';
                editButton.addEventListener('click', () => editTodo(index));
                li.appendChild(editButton);

                const deleteButton = document.createElement('button');
                deleteButton.textContent = 'Delete';
                deleteButton.addEventListener('click', () => deleteTodo(index));
                li.appendChild(deleteButton);

                todoList.appendChild(li);
            });
        }

        // Add a new todo
        newTodoInput.addEventListener('keydown', (event) => {
            if (event.key === 'Enter') {
                const newTodo = newTodoInput.value.trim();
                if (newTodo) {
                    todos.push(newTodo);
                    newTodoInput.value = '';
                    renderTodos();
                }
            }
        });

        // Edit a todo
        function editTodo(index) {
            const newTodo = prompt('Edit todo', todos[index]);
            if (newTodo !== null) {
                todos[index] = newTodo.trim();
                renderTodos();
            }
        }

        // Delete a todo
        function deleteTodo(index) {
            todos.splice(index, 1);
            renderTodos();
        }

        // Render initial todos
        renderTodos();
    </script>
</body>
</html>
```

```php
<?php
// No PHP code required for this simple Todo List App
```