
<?php
// Check if db.json file exists
$db_file = 'db.json';
if (!file_exists($db_file)) {
    // Create the file if it doesn't exist
    file_put_contents($db_file, '{"todos":[]}');
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents($db_file), true);
    $todo = trim($_POST['todo']);
    if (!empty($todo)) {
        $data['todos'][] = array('text' => $todo, 'completed' => false);
        file_put_contents($db_file, json_encode($data));
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Handle todo completion
if (isset($_GET['complete'])) {
    $data = json_decode(file_get_contents($db_file), true);
    $index = $_GET['complete'];
    if (isset($data['todos'][$index])) {
        $data['todos'][$index]['completed'] = !$data['todos'][$index]['completed'];
        file_put_contents($db_file, json_encode($data));
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Handle todo deletion
if (isset($_GET['delete'])) {
    $data = json_decode(file_get_contents($db_file), true);
    $index = $_GET['delete'];
    if (isset($data['todos'][$index])) {
        array_splice($data['todos'], $index, 1);
        file_put_contents($db_file, json_encode($data));
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>
```

```html
<!DOCTYPE html>
<html>
<head>
    <title>Todo App</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <h1>Todo App</h1>
    <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <input type="text" name="todo" placeholder="Enter a new todo" required>
        <button type="submit">Add Todo</button>
    </form>
    <ul>
        <?php
        $data = json_decode(file_get_contents($db_file), true);
        foreach ($data['todos'] as $index => $todo) {
            $completed = $todo['completed'] ? 'completed' : '';
            echo "<li class='$completed'>";
            echo "<span>" . htmlspecialchars($todo['text']) . "</span>";
            echo "<a href='?complete=$index'>Mark as " . ($completed ? 'Incomplete' : 'Complete') . "</a>";
            echo "<a href='?delete=$index'>Delete</a>";
            echo "</li>";
        }
        ?>
    </ul>
    <script src="script.js"></script>
</body>
</html>
```

```css
body {
    font-family: Arial, sans-serif;
    margin: 20px;
}

h1 {
    text-align: center;
}

form {
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
}

input[type="text"] {
    padding: 5px;
    font-size: 16px;
    flex: 1;
}

button {
    padding: 5px 10px;
    font-size: 16px;
}

ul {
    list-style-type: none;
    padding: 0;
}

li {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 10px;
    border-bottom: 1px solid #ddd;
}

li.completed span {
    text-decoration: line-through;
    color: #888;
}

a {
    color: #333;
    text-decoration: none;
    margin-left: 10px;
}

a:hover {
    text-decoration: underline;
}
```

```javascript
// You can add JavaScript functionality here if needed
```