
<?php
// Check if todo.json file exists, if not create it
if (!file_exists('todo.json')) {
    $initialData = array();
    file_put_contents('todo.json', json_encode($initialData));
}

// Get todo list data from todo.json file
$todoData = json_decode(file_get_contents('todo.json'), true);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Todo List App</title>
    <style>
        .completed {
            text-decoration: line-through;
            color: gray;
        }
    </style>
</head>
<body>
    <h1>Todo List</h1>
    <input type="text" id="newTodo" placeholder="Enter a new todo...">
    <button onclick="addTodo()">Add</button>
    <ul id="todoList">
        <?php foreach ($todoData as $todo): ?>
            <li class="<?php echo $todo['completed'] ? 'completed' : ''; ?>">
                <?php echo $todo['text']; ?>
                <button onclick="toggleCompleted(<?php echo $todo['id']; ?>)">Toggle</button>
                <button onclick="editTodo(<?php echo $todo['id']; ?>)">Edit</button>
                <button onclick="deleteTodo(<?php echo $todo['id']; ?>)">Delete</button>
            </li>
        <?php endforeach; ?>
    </ul>

    <script>
        let todoData = <?php echo json_encode($todoData); ?>;

        function addTodo() {
            const newTodoInput = document.getElementById('newTodo');
            const newTodoText = newTodoInput.value.trim();
            if (newTodoText !== '') {
                const newTodo = {
                    id: Date.now(),
                    text: newTodoText,
                    completed: false
                };
                todoData.push(newTodo);
                updateTodoList();
                newTodoInput.value = '';
            }
        }

        function toggleCompleted(id) {
            todoData = todoData.map(todo => {
                if (todo.id === id) {
                    return { ...todo, completed: !todo.completed };
                }
                return todo;
            });
            updateTodoList();
        }

        function editTodo(id) {
            const newTodoText = prompt('Enter new todo text', todoData.find(todo => todo.id === id).text);
            if (newTodoText !== null && newTodoText.trim() !== '') {
                todoData = todoData.map(todo => {
                    if (todo.id === id) {
                        return { ...todo, text: newTodoText };
                    }
                    return todo;
                });
                updateTodoList();
            }
        }

        function deleteTodo(id) {
            todoData = todoData.filter(todo => todo.id !== id);
            updateTodoList();
        }

        function updateTodoList() {
            const todoListElement = document.getElementById('todoList');
            todoListElement.innerHTML = '';
            todoData.forEach(todo => {
                const li = document.createElement('li');
                li.textContent = todo.text;
                if (todo.completed) {
                    li.classList.add('completed');
                }
                const toggleButton = document.createElement('button');
                toggleButton.textContent = 'Toggle';
                toggleButton.onclick = () => toggleCompleted(todo.id);
                li.appendChild(toggleButton);
                const editButton = document.createElement('button');
                editButton.textContent = 'Edit';
                editButton.onclick = () => editTodo(todo.id);
                li.appendChild(editButton);
                const deleteButton = document.createElement('button');
                deleteButton.textContent = 'Delete';
                deleteButton.onclick = () => deleteTodo(todo.id);
                li.appendChild(deleteButton);
                todoListElement.appendChild(li);
            });
            saveToFile();
        }

        function saveToFile() {
            const data = JSON.stringify(todoData);
            const file = new Blob([data], { type: 'application/json' });
            const a = document.createElement('a');
            a.href = URL.createObjectURL(file);
            a.download = 'todo.json';
            a.click();
        }
    </script>
</body>
</html>
```