<?php
$projectsDir = 'projects/';
$projectName = $_GET['project'] ?? '';
$fileName = $_GET['file'] ?? '';

if ($projectName) {
    $projectPath = $projectsDir . $projectName;
    $versionsPath = $projectPath . '/versions.json';

    $versions = [];
    if (file_exists($versionsPath)) {
        $versions = json_decode(file_get_contents($versionsPath), true);
    }
} else {
    $versions = [];
}

function generateDiff($oldCode, $newCode) {
    $oldLines = explode("\n", $oldCode);
    $newLines = explode("\n", $newCode);
    $diff = [];

    $matrix = array();
    foreach ($oldLines as $oindex => $ovalue) {
        $nkeys = array_keys($newLines, $ovalue);
        foreach ($nkeys as $nindex) {
            $matrix[$oindex][$nindex] = isset($matrix[$oindex - 1][$nindex - 1]) ?
                $matrix[$oindex - 1][$nindex - 1] + 1 : 1;
            if ($matrix[$oindex][$nindex] > $maxlen) {
                $maxlen = $matrix[$oindex][$nindex];
                $omax = $oindex + 1 - $maxlen;
                $nmax = $nindex + 1 - $maxlen;
            }
        }
    }

    $omax = $nmax = 0;
    while ($omax < count($oldLines) || $nmax < count($newLines)) {
        if ($omax < count($oldLines) && $nmax < count($newLines) && $oldLines[$omax] === $newLines[$nmax]) {
            $diff[] = ['type' => 'unchanged', 'line' => $oldLines[$omax]];
            $omax++;
            $nmax++;
        } elseif ($nmax < count($newLines) && ($omax >= count($oldLines) || $matrix[$omax][$nmax + 1] >= $matrix[$omax + 1][$nmax])) {
            $diff[] = ['type' => 'added', 'line' => $newLines[$nmax]];
            $nmax++;
        } else {
            $diff[] = ['type' => 'removed', 'line' => $oldLines[$omax]];
            $omax++;
        }
    }

    return $diff;
}

function renderDiff($diff) {
    $output = '';
    foreach ($diff as $change) {
        switch ($change['type']) {
            case 'unchanged':
                $output .= '  ' . htmlspecialchars($change['line']) . "\n";
                break;
            case 'added':
                $output .= '<span class="diff-added">+ ' . htmlspecialchars($change['line']) . "</span>\n";
                break;
            case 'removed':
                $output .= '<span class="diff-removed">- ' . htmlspecialchars($change['line']) . "</span>\n";
                break;
        }
    }
    return $output;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Version History: <?php echo htmlspecialchars($projectName); ?> - <?php echo htmlspecialchars($fileName); ?></title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; padding: 20px; }
        h1 { color: #333; }
        pre { background-color: #f4f4f4; padding: 15px; overflow-x: auto; }
        .diff { white-space: pre; font-family: monospace; }
        .diff-added { background-color: #e6ffed; display: block; }
        .diff-removed { background-color: #ffeef0; display: block; }
        .collapsible { 
            background-color: #777;
            color: white;
            cursor: pointer;
            padding: 18px;
            width: 100%;
            border: none;
            text-align: left;
            outline: none;
            font-size: 15px;
            margin-bottom: 10px;
        }
        .active, .collapsible:hover { background-color: #555; }
        .content {
            padding: 0 18px;
            display: none;
            overflow: hidden;
            background-color: #f1f1f1;
        }
        .version-info { margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>Version History: <?php echo htmlspecialchars($projectName); ?> - <?php echo htmlspecialchars($fileName); ?></h1>
    <a href="edit.php?project=<?php echo urlencode($projectName); ?>&file=<?php echo urlencode($fileName); ?>">Back to Edit Page</a>

    <?php if (empty($versions)): ?>
        <p>No version history found for this file.</p>
    <?php else: ?>
        <?php 
        $versions = array_reverse($versions);
        foreach ($versions as $index => $version): 
            if ($version['file'] !== $fileName) continue;
        ?>
            <div class="version-info">
                <h2>Version <?php echo count($versions) - $index; ?></h2>
                <p><strong>Timestamp:</strong> <?php echo htmlspecialchars($version['timestamp']); ?></p>
                <p><strong>Request:</strong> <?php echo htmlspecialchars($version['request']); ?></p>
                <button class="collapsible">View Full Code</button>
                <div class="content">
                    <pre><code><?php echo htmlspecialchars($version['newCode']); ?></code></pre>
                </div>
                <?php if (isset($versions[$index + 1])): ?>
                    <button class="collapsible">View Changes from Previous Version</button>
                    <div class="content">
                        <div class="diff">
                            <?php
                            $prevVersion = $versions[$index + 1];
                            $diff = generateDiff($prevVersion['newCode'], $version['newCode']);
                            echo renderDiff($diff);
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <script>
    var coll = document.getElementsByClassName("collapsible");
    var i;

    for (i = 0; i < coll.length; i++) {
        coll[i].addEventListener("click", function() {
            this.classList.toggle("active");
            var content = this.nextElementSibling;
            if (content.style.display === "block") {
                content.style.display = "none";
            } else {
                content.style.display = "block";
            }
        });
    }
    </script>
</body>
</html>