<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\WeatherData as WeatherData;

class FetchWeatherData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'weather:fetch-latest-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fetch data from openweathermap.org and save to our database';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $command = new WeatherData();
        $command->syncronize();
        return Command::SUCCESS;
    }
}
