<?php
libxml_use_internal_errors(true);

error_reporting(E_ERROR | E_WARNING | E_PARSE);

$now = new DateTime(null, new DateTimeZone('Europe/Berlin'));
$now = $now->modify('+3 minutes');
$content = file_get_contents("https://fahrinfo.bvg.de/Fahrinfo/bin/stboard.bin/dn?L=&maxJourneys=30&input=900131508&boardType=dep&start=1&application=&selectDate=today&dateBegin=10.12.20&performTransferSearch=Filtern");
//$content = json_decode(file_get_contents('ex.html'));

//$content = file_get_contents("ex.html");
$doc = new DOMDocument();

$doc->loadHTML($content);

$trs = $doc->getElementsByTagName('tr');
$setMitte = 0;$setRosen = 0;
foreach ($trs as $tr) {
    
    if (strpos($tr->nodeValue, 'Rosenthal') !== false) {
        if($rosenthalMinutesNextTram['useable']) continue;
        $rosenthalMinutesNextTram = getNextTram($tr, $now, $setRosen);
    }
    
    if (strpos($tr->nodeValue, 'Rosenthal') === false) {
        if($mitteMinutesNextTram['useable']) continue;
        $mitteMinutesNextTram = getNextTram($tr, $now, $setMitte);

    }
}


?>
<!-- const int colorR = <?php echo rand(0,255); ?>; const int colorG = <?php echo rand(0,255); ?>; const int colorB = <?php echo rand(0,255); ?> --!>
<!--const String Timetable1 = "!-->M1 Mitte     <?php echo $mitteMinutesNextTram['minutes'] <= 0 ? 'DUE' : $mitteMinutesNextTram['minutes']; ?>'<!--";--!>
<br/>
<!-- const String Timetable2 = "!-->M1 Rosenthal <?php echo $rosenthalMinutesNextTram['minutes'] <= 1 ? 'DUE' : $rosenthalMinutesNextTram['minutes']; ?>'<!--";--!>


<?php

function getNextTram($tr, $now, &$set){
    if ($set) return;
        
    $time = substr($tr->nodeValue, 1, 7);
    
    if(strpos($time, 'Zeit')) 
        return;
        
    if(!strpos($tr->nodeValue, 'M1')) 
        return;
    
    if ((substr($tr->nodeValue, 1, 3) == $now->format('H')) && substr($tr->nodeValue, 5, 7) < $now->format('i')) {
        return;
    }
    
    if (substr($tr->nodeValue, 1, 3) == 23 && $now->format('H') == 00) {
        return;
    }
    
    $dt = new DateTime($now->format("Y-m-d" . $time), new DateTimeZone('Europe/Berlin'));

    $diff = time_Diff_Minutes($now->format("Y-m-d H:i"), $dt->format("Y-m-d H:i"));
    
    return ['useable' => true, 'minutes' => $diff];
}

function time_Diff_Minutes($startTime, $endTime) {

        $to_time = strtotime($endTime);
        $from_time = strtotime($startTime);
        $minutes = ($to_time - $from_time) / 60; 
        return ($minutes < 0 ? 0 : abs($minutes));   

 } 
