<?php

declare(strict_types=1);

namespace App\Presenters;

use Nette;
use Nette\Application\UI;


final class FeedlyPresenter extends Nette\Application\UI\Presenter
{
    public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}
	
    public function beforeRender(): void
    { 
        parent::beforeRender();
        $this->redrawControl('articles');
    }
    
    public function handleMore($id, $continuation): void
    {
        if ($this->isAjax()) {
            $idDecoded = str_replace('_', '/', $id);
            $this->payload->articles[$idDecoded]['items'] = $this->getArticles($idDecoded, $continuation, 'streams', 4);
        } else {
			$this->redirect('this');
		}
    }
	
	public function renderDefault($id, $continuous): void
    {
        $authfile = 'http://winder.nom.za/text/feedly/auth.txt';
        $auth = file_get_contents($authfile);
        $bearer = trim($auth);
        $type = 'streams';
        $count = 4;
        
        //$template = $this->createTemplate();
        
        foreach(json_decode($this->getFeedlyBoards($bearer),true) as $board)
        {
            if(isset($board['id']))
            {
                $this->template->boards[$board['id']] = [
                    'id' => $board['id'], 
                    'name' => $board['label']
                ];
                
                $this->template->boards[$board['id']]['items'] = $this->getArticles($board['id']);

            }
        }
        
        //$this->sendTemplate($template);
    }
    
    public function getArticles($id, $continuation = null, $type = 'streams', $count = 4)
    { 
        $authfile = 'http://winder.nom.za/text/feedly/auth.txt';
        $auth = file_get_contents($authfile);
        $bearer = trim($auth);
        
        $feedFetchUrl = 'https://api.feedly.com/v3/' . $type . '/contents?streamId=' . $id . '&count=' . $count . '&continuation=' . $continuation . '&count=20&unreadOnly=true&ranked=newest&similar=true&findUrlDuplicates=true&ck=1685633710856&ct=feedly.desktop&cv=31.0.1805';
        $content = json_decode($this->getFeedlyContent($feedFetchUrl), true);
        
        foreach($content['items'] as $item)
        {
            $items['items'][] = [
                'url' => 'http://winder.nom.za/text/abc/public/feedly/keywords?url=' . $item['alternate'][0]['href'],
                'origin' => $item['origin']['title'],
                'title' => ucfirst(strtolower($item['title'])),
                'continuation' => $content['continuation']
                ];
        }
        $items['continuation'] = $content['continuation'];
        return $items;
    }
    
    function getFeedlyBoards()
    {
        
        $authfile = 'http://winder.nom.za/text/feedly/auth.txt';
        $auth = file_get_contents($authfile);
        $bearer = trim($auth);
        
        $feed = 'https://api.feedly.com/v3/collections?withStats=true&ck=1683211903551&ct=feedly.desktop&cv=31.0.1792';
        
        $file = '/home/richwestcoast/winder.nom.za/text/feedly/cache/' . md5($feed);
        
        if(file_exists($file))
        {
                
            if($response = file_get_contents($file)){
            
            if(strlen($response) > 1000){
              $age = \DateTime::__set_state(json_decode($response, true)['age']);
              $now = new \DateTime();
              $diffInSeconds = $now->getTimestamp() - $age->getTimestamp();
              if($diffInSeconds < 600){
                return $response;
              }
            }
            }
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $feed,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
          'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:103.0) Gecko/20100101 Firefox/103.0',
          'Accept: */*',
          'Accept-Language: en-US,en;q=0.5',
          'Accept-Encoding: gzip, deflate, br',
          'Authorization: ' . $auth,
          'Content-Type: application/json',
          'Alt-Used: feedly.com',
          'Connection: keep-alive',
          'Referer: https://feedly.com/i/my',
          'Cache-Control: no-cache',
          'TE: trailers'
        ),
        ));
        
        $responseJson = curl_exec($curl);
        $response = json_decode($responseJson, true);
        
        $response['age'] = new \DateTime();
        
        $responseJson = json_encode($response);
        
        curl_close($curl);
        
        file_put_contents('/home/richwestcoast/winder.nom.za/text/feedly/cache/' . md5($feed), $responseJson);
        
        return $responseJson;
    }
    
    function getFeedlyContent($feed){
        
        $authfile = 'http://winder.nom.za/text/feedly/auth.txt';
        $auth = file_get_contents($authfile);
        $bearer = trim($auth);
        
        $file = '/home/richwestcoast/winder.nom.za/text/feedly/cache/' . md5($feed);
        
        if(file_exists($file))
        {
            if($response = file_get_contents($file)){
            
                if(strlen($response) > 1000){
                  $age = \DateTime::__set_state(json_decode($response, true)['age']);
                  $now = new \DateTime();
                  $diffInSeconds = $now->getTimestamp() - $age->getTimestamp();
                  if($diffInSeconds < 600){
                    return $response;
                  }
                }
            }
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $feed,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
          'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:103.0) Gecko/20100101 Firefox/103.0',
          'Accept: */*',
          'Accept-Language: en-US,en;q=0.5',
          'Accept-Encoding: gzip, deflate, br',
          'Authorization: ' . $auth,
          'Content-Type: application/json',
          'Alt-Used: feedly.com',
          'Connection: keep-alive',
          'Referer: https://feedly.com/i/my',
          'Cache-Control: no-cache',
          'TE: trailers'
        ),
        ));
        
        $responseJson = curl_exec($curl);
        $response = json_decode($responseJson, true);
        
        $response['age'] = new \DateTime();
        
        $responseJson = json_encode($response);
        
        curl_close($curl);
        
        file_put_contents('/home/richwestcoast/winder.nom.za/text/feedly/cache/' . md5($feed), $responseJson);
        
        return $responseJson;
    }
}