<?php
declare(strict_types=1);

namespace App\Presenters;

use Nette;
use Nette\Application\UI;
	
	
class FirstPresenter extends Nette\Application\UI\Presenter
{
	/**
	 * This method returns data for the list.
	 * Usually this would just request the data from a model.
	 * For the purpose of this example, the data is hard-coded.
	 */
	private function getTheWholeList(): array
	{
		$list[0]['title'] = 'first';
		$list[0]['children'][]['title'] = 'small introduction...';
		$list[1]['title'] = 'second';
		$list[1]['children'][]['title'] = 'second - first child';
		$list[2]['title'] = 'third';
		$list[2]['children'][]['title'] = 'third - first child';
		
		return $list;
	}

	public function renderDefault(): void
	{
		
		if (!isset($this->template->list)) {
			$this->template->list = $this->getTheWholeList();
		}
	}
	
	public function actionReadmore($id): void
	{
		echo 'hello';
		$this->template->id = $id;
	}

	public function handleParentUpdate(int $parentId): void
	{
		$this->template->list = $this->isAjax()
				? []
				: $this->getTheWholeList();
		$this->template->list[$parentId]['title'] = 'Updated item';
		$this->redrawControl('readmore');
		$this->redrawControl('itemsContainer');
	}
	
	public function handleChildUpdate(): void
	{
		
	}
}
