<?php
declare(strict_types=1);

namespace App\Presenters;

use Nette;
use Nette\Application\UI;
	
	
class HomePresenter extends Nette\Application\UI\Presenter
{
	public $auth;
	public $bearer;
	
	public function __construct()
	{
		$authfile = 'http://winder.nom.za/text/feedly/auth.txt';
		$this->auth = file_get_contents($authfile);
		$this->bearer = trim($this->auth);
	}
	
	private function getInitialList(): array
	{
		foreach($this->getFeedlyBoards() as $board)
		{
			if(!isset($board['id']))
				continue;
				
			$encodedID = str_replace('/', '&', $board['id']);
			$list[$encodedID]['name'] = $board['label'];
			$articles = $this->getArticles($board['id']);
			
			foreach($articles['items'] as $article)
			{
				$list[$encodedID]['items'][str_replace('/', '^', $article['url'])] = 
				['title' => $article['title'], 'content' => $article['content'], 'url' => $article['url']];
			}
			$list[$encodedID]['continuation'] = $articles['continuation'];
			
		}
		
		return $list;
	}
	
	public function renderDefault(): void
	{
		if (!isset($this->template->list)) {
			$this->template->list = $this->getInitialList();
		}
	}
	
	public function actionReadmore($url)
	{
		$this->template->url = str_replace('%', '/', $url);
		bdump($this->template->url);
		$this->template->content = '<h1>' . explode('<h1>', file_get_contents(str_replace('%', '/', $url)))[1];
		$this->redrawControl('readmore');
	}
	
	public function handleMore($id, $continuation): void
	{
		$decodedID = str_replace('&', '/', $id);
		$this->template->list = $this->isAjax() ? []: $this->getInitialList();
		$this->template->list[$id]['name'] = $id;
		$articles = $this->getArticles($decodedID, $continuation);
		foreach($articles['items'] as $article)
		{
			$this->template->list[$id]['items'][str_replace('/', '^', $article['url'])] = 
			['title' => $article['title'], 'content' => $article['content'], 'url' => str_replace('/', '%', $article['url'])];
		}
		$this->template->list[$id]['continuation'] = $articles['continuation'];
		$this->redrawControl('itemsContainer');
	}
	
	public function beforeRender(): void
	{
		parent::beforeRender();
		$this->redrawControl('itemsContainer');
	}
	
	public function getArticles($id, $continuation = null, $type = 'streams', $count = 6)
	{ 
		
		$feedFetchUrl = 'https://api.feedly.com/v3/' . $type . '/contents?streamId=' . $id . '&count=' . $count . '&continuation=' . $continuation . '&count=20&unreadOnly=true&ranked=newest&similar=true&findUrlDuplicates=true&ck=1685633710856&ct=feedly.desktop&cv=31.0.1805';
		$content = $this->getFeedlyContent($feedFetchUrl);
		$items = [];
		if(isset($content['items']))
		{
			foreach($content['items'] as $item)
			{
				$summary = 'No summary...';
				if(isset($item['summary']))
				{
					$summary = $item['summary']['content'];
				}
				$items['items'][] = [
					'url' => str_replace('/', '%', 'http://winder.nom.za/text/abc/public/feedly/keywords?url=' . $item['alternate'][0]['href']),
					'origin' => $item['origin']['title'],
					'content' => $summary, 
					'title' => ucfirst(strtolower($item['title'])),
					'continuation' => $content['continuation']
					];
			}
			$items['continuation'] = $content['continuation'];
		}
		return $items;
	}
	
	function getFeedlyBoards()
	{
		$feed = 'https://api.feedly.com/v3/collections?withStats=true&ck=1683211903551&ct=feedly.desktop&cv=31.0.1792';
		
		$file = '/rw/www/nette/feedly_cache/' . md5($feed);
		
		if(file_exists($file))
		{
				
			if($response = file_get_contents($file)){
			
			if(strlen($response) > 1000){
			  $age = \DateTime::__set_state(json_decode($response, true)['age']);
			  $now = new \DateTime();
			  $diffInSeconds = $now->getTimestamp() - $age->getTimestamp();
			  if($diffInSeconds < 600){
				return json_decode($response,true);
			  }
			}
			}
		}
	
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => $feed,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'GET',
		CURLOPT_HTTPHEADER => array(
		  'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:103.0) Gecko/20100101 Firefox/103.0',
		  'Accept: */*',
		  'Accept-Language: en-US,en;q=0.5',
		  'Accept-Encoding: gzip, deflate, br',
		  'Authorization: ' . $this->auth,
		  'Content-Type: application/json',
		  'Alt-Used: feedly.com',
		  'Connection: keep-alive',
		  'Referer: https://feedly.com/i/my',
		  'Cache-Control: no-cache',
		  'TE: trailers'
		),
		));
		
		$responseJson = curl_exec($curl);
		$response = json_decode($responseJson, true);
		
		$response['age'] = new \DateTime();
		
		$responseJson = json_encode($response);
		
		curl_close($curl);
		
		file_put_contents('/rw/www/nette/feedly_cache/' . md5($feed), $responseJson);
		
		return json_decode($responseJson,true);
	}
	
	function getFeedlyContent($feed){
		$file = '/rw/www/nette/feedly_cache/' . md5($feed);
		
		if(file_exists($file))
		{
			if($response = file_get_contents($file)){
			
				if(strlen($response) > 1000){
				  $age = \DateTime::__set_state(json_decode($response, true)['age']);
				  $now = new \DateTime();
				  $diffInSeconds = $now->getTimestamp() - $age->getTimestamp();
				  if($diffInSeconds < 600){
					return json_decode($response,true);
				  }
				}
			}
		}
	
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => $feed,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'GET',
		CURLOPT_HTTPHEADER => array(
		  'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:103.0) Gecko/20100101 Firefox/103.0',
		  'Accept: */*',
		  'Accept-Language: en-US,en;q=0.5',
		  'Accept-Encoding: gzip, deflate, br',
		  'Authorization: ' . $this->auth,
		  'Content-Type: application/json',
		  'Alt-Used: feedly.com',
		  'Connection: keep-alive',
		  'Referer: https://feedly.com/i/my',
		  'Cache-Control: no-cache',
		  'TE: trailers'
		),
		));
		
		$responseJson = curl_exec($curl);
		$response = json_decode($responseJson, true);
		
		$response['age'] = new \DateTime();
		
		$responseJson = json_encode($response);
		
		curl_close($curl);
		
		file_put_contents('/rw/www/nette/feedly_cache/' . md5($feed), $responseJson);
		
		return $response;
	}
	
}