<?php

namespace App\Presenters;

use Nette;
use Nette\Application\UI;
use Tracy\Debugger;
use Tracy\ILogger;

final class PostPresenter extends Nette\Application\UI\Presenter
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}
	
	public function renderShow(int $postId): void
	{
		Debugger::log("This is a debug message");
		$post = $this->database
			->table('posts')
			->get($postId);
			if(!$post) {
				$this->error('Post not found');
			}
			
			$this->template->post = $post;
			$this->template->comments = $post->related('comments')->order('created_at');
			
			$this->template->post = $post;
	}
	
	public function handleRemove($id): void
	{
		$this->database->query('DELETE FROM comments WHERE id = ?', $id);
		$this->redrawControl();
	}
	
	protected function createComponentCommentForm(): UI\Form
	{
		$form = new UI\Form;
		$form->setHtmlAttribute('class', 'ajax');
		
		$form->addText('name', 'Your name:')
			->setRequired('Name must be filled');
		$form->addEmail('email', 'Email:')
			->setRequired('E-mail must be filled');
		$form->addTextArea('content', 'Comment:')
			->setRequired('Content must be filled');
		$form->addSubmit('send', 'Publish comment');
		
		$form->onSuccess[] = [$this, 'commentFormSucceeded'];
		
		return $form;
	}
	
	public function commentFormSucceeded(UI\Form $form, \stdClass $values): void
	{
		$postId = $this->getParameter('postId');
		
		$this->database->table('comments')->insert([
			'post_id' => $postId,
			'name' => $form->getHttpData()['name'],
			'email' => $form->getHttpData()['email'],
			'content' => $form->getHttpData()['content'],
		]);
	
		$this->flashMessage('Thank you for your comment', 'success');
		
		if ($this->isAjax()) {
			$this->redrawControl();
			
			// To manage the history api ------------------------------------
		    $this->payload->postGet = TRUE;
		    $this->payload->url = $this->link('Post:show', 3);
		    // --------------------------------------------------------------
		} else {
			$this->redirect('this');
		}
	}
	
	public function commentFormFailed(UI\Form $form): void
	{
		if ($this->isAjax()) {
			$this->redrawControl('letterForm');
		}
	}
	
	public function beforeRender(): void
	{
	    parent::beforeRender();
	    $this->redrawControl('title'); 
	    $this->redrawControl('content');
	}

}