<?php
declare(strict_types=1);

namespace App\Presenters;

use Nette;
use Nette\Application\UI;
	
	
class SecondPresenter extends Nette\Application\UI\Presenter
{
    public function renderDefault(): void
	{
	    $this->template->boards = $this->getBoards();
	    $this->template->title = 'Choose a category';
	    $this->redrawControl('content');
	}
	
	public function renderBoard($id): void
	{
	    //$id = json_decode(urldecode($id), true)['id'];
	    $this->template->articles = $this->getArticles($id);
	    $this->template->title = "Pick an article";
	    $this->redrawControl('content');
	}
	
	public function renderArticle($id): void
	{
		$this->template->article = $this->getArticle($id);
	    $this->template->title = 'Article: ' . $id;
	    $this->template->url = $id;
	    
	    $this->template->articleTranslate = "No translation yet.";
	    $this->redrawControl('content');
	}
	
	public function actionSummary($id): void
	{
		$this->template->article = $this->getArticle($id, "false", "true");
	    $this->redrawControl('articleSummary');
	}
	
	public function actionTitle($id): void
	{
		$this->template->article = $this->getArticle($id, "true");
	    $this->redrawControl('articleTitle');
	}
	
	public function actionTranslate($id): void
	{
		$this->template->article = $this->getArticle($id, "false", "false", "true");
	    $this->redrawControl('articleTranslate');
	}
	
	public function getFeeds($id)
	{
		$boardsJson = json_decode(file_get_contents("http://winder.nom.za/text/abc/public/feedly/boards.json"), true);
		foreach($boardsJson as $board)
        {
        	if($board['id'] != $id)
        		continue;
        		
        	$feeds = $board['feeds'];
        }
        
        return $feeds;
	}
	
	public function getBoards()
	{
	    $boardsJson = json_decode(file_get_contents("http://winder.nom.za/text/abc/public/feedly/boards.json"), true);
	    foreach($boardsJson as $board)
        {
	        if(!isset($board['id']))
	        continue;
	        
	        //dump(print_r($board, true));
	        
            $boards[] = [
            'id' => urlencode(json_encode(['id' => $board['id']])),
            'label' => $board['label'],
            ];
	        //dump(print_r($board['label'], true));
	        
	        
	    }
	    
	    return $boards;
	}
	
	public function getArticles($id)
	{
		
	    $articles = json_decode(file_get_contents("http://winder.nom.za/text/abc/public/feedly/".urlencode($id)."/articles.json"), true);

	    return $articles['items'];
	}
	
	public function getArticle($url, $trans_title = "false", $trans_summary = "false", $trans_article = "false", $article_bookmark = "false", $article_read = "false")
	{
		$url = 'http://winder.nom.za/text/abc/public/feedly/' . urlencode($url) . '/' . $trans_title . '/' . $trans_summary . '/' . $trans_article . '/' . $article_bookmark . '/' . $article_read . '/article.json';

	    return json_decode(file_get_contents($url), true);
	}
}