import { UIHandler } from './core/UIHandler';
import { FormsHandler } from './core/FormsHandler';
import { RedirectHandler } from './core/RedirectHandler';
import { SnippetHandler } from './core/SnippetHandler';
import { HistoryHandler } from './core/HistoryHandler';
import { SnippetCache } from './core/SnippetCache';
import { ScriptLoader } from './core/ScriptLoader';
import { TypedEventListener } from './utils';
export interface Options extends Record<string, any> {
    fetch?: RequestInit;
}
export interface Payload extends Record<string, any> {
}
export declare class Naja extends EventTarget {
    readonly VERSION: number;
    private initialized;
    readonly uiHandler: UIHandler;
    readonly redirectHandler: RedirectHandler;
    readonly snippetHandler: SnippetHandler;
    readonly formsHandler: FormsHandler;
    readonly historyHandler: HistoryHandler;
    readonly snippetCache: SnippetCache;
    readonly scriptLoader: ScriptLoader;
    private readonly extensions;
    defaultOptions: Options;
    constructor(uiHandler?: {
        new (naja: Naja): UIHandler;
    }, redirectHandler?: {
        new (naja: Naja): RedirectHandler;
    }, snippetHandler?: {
        new (naja: Naja): SnippetHandler;
    }, formsHandler?: {
        new (naja: Naja): FormsHandler;
    }, historyHandler?: {
        new (naja: Naja): HistoryHandler;
    }, snippetCache?: {
        new (naja: Naja): SnippetCache;
    }, scriptLoader?: {
        new (naja: Naja): ScriptLoader;
    });
    registerExtension(extension: Extension): void;
    initialize(defaultOptions?: Options): void;
    prepareOptions(options?: Options): Options;
    makeRequest(method: string, url: string | URL, data?: any | null, options?: Options): Promise<Payload>;
    private appendToQueryString;
    private transformData;
    addEventListener: <K extends keyof NajaEventMap | string>(type: K, listener: TypedEventListener<Naja, K extends keyof NajaEventMap ? NajaEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
    removeEventListener: <K extends keyof NajaEventMap | string>(type: K, listener: TypedEventListener<Naja, K extends keyof NajaEventMap ? NajaEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
}
export interface Extension {
    initialize(naja: Naja): void;
}
export declare class HttpError extends Error {
    readonly response: Response;
    constructor(response: Response);
}
export declare type InitEvent = CustomEvent<{
    defaultOptions: Options;
}>;
export declare type BeforeEvent = CustomEvent<{
    request: Request;
    method: string;
    url: string;
    data: any;
    options: Options;
}>;
export declare type StartEvent = CustomEvent<{
    request: Request;
    promise: Promise<Response>;
    abortController: AbortController;
    options: Options;
}>;
export declare type AbortEvent = CustomEvent<{
    request: Request;
    error: Error;
    options: Options;
}>;
export declare type PayloadEvent = CustomEvent<{
    request: Request;
    response: Response;
    payload: Payload;
    options: Options;
}>;
export declare type SuccessEvent = CustomEvent<{
    request: Request;
    response: Response;
    payload: Payload;
    options: Options;
}>;
export declare type ErrorEvent = CustomEvent<{
    request: Request;
    response: Response | undefined;
    error: Error;
    options: Options;
}>;
export declare type CompleteEvent = CustomEvent<{
    request: Request;
    response: Response | undefined;
    error: Error | undefined;
    payload: Payload | undefined;
    options: Options;
}>;
interface NajaEventMap {
    init: InitEvent;
    before: BeforeEvent;
    start: StartEvent;
    abort: AbortEvent;
    payload: PayloadEvent;
    success: SuccessEvent;
    error: ErrorEvent;
    complete: CompleteEvent;
}
export {};
