import { Naja, Options } from '../Naja';
import { TypedEventListener } from '../utils';
declare module '../Naja' {
    interface Options {
        history?: HistoryMode;
        href?: string;
    }
    interface Payload {
        postGet?: boolean;
        url?: string;
    }
}
export interface HistoryState extends Record<string, any> {
    source: string;
    href: string;
}
export interface HistoryAdapter {
    replaceState(state: HistoryState, title: string, url: string): void;
    pushState(state: HistoryState, title: string, url: string): void;
}
export declare type HistoryMode = boolean | 'replace';
export declare class HistoryHandler extends EventTarget {
    private readonly naja;
    private initialized;
    popStateHandler: (event: PopStateEvent) => void;
    historyAdapter: HistoryAdapter;
    constructor(naja: Naja);
    set uiCache(value: boolean);
    private handlePopState;
    private initialize;
    private saveUrl;
    private replaceInitialState;
    private configureMode;
    static normalizeMode(mode: string | boolean | null | undefined): HistoryMode;
    private pushNewState;
    private buildState;
    addEventListener: <K extends keyof HistoryHandlerEventMap | string>(type: K, listener: TypedEventListener<HistoryHandler, K extends keyof HistoryHandlerEventMap ? HistoryHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
    removeEventListener: <K extends keyof HistoryHandlerEventMap | string>(type: K, listener: TypedEventListener<HistoryHandler, K extends keyof HistoryHandlerEventMap ? HistoryHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
}
export declare type BuildStateEvent = CustomEvent<{
    state: HistoryState;
    options: Options;
}>;
export declare type RestoreStateEvent = CustomEvent<{
    state: HistoryState;
    options: Options;
}>;
interface HistoryHandlerEventMap {
    buildState: BuildStateEvent;
    restoreState: RestoreStateEvent;
}
export {};
