import { Naja, Options } from '../Naja';
import { TypedEventListener } from '../utils';
declare module '../Naja' {
    interface Options {
        forceRedirect?: boolean;
    }
    interface Payload {
        redirect?: string;
    }
}
interface LocationAdapter {
    assign(url: string): void;
}
export declare class RedirectHandler extends EventTarget {
    private readonly naja;
    locationAdapter: LocationAdapter;
    constructor(naja: Naja);
    makeRedirect(url: string | URL, force: boolean, options?: Options): void;
    addEventListener: <K extends keyof RedirectHandlerEventMap | string>(type: K, listener: TypedEventListener<RedirectHandler, K extends keyof RedirectHandlerEventMap ? RedirectHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
    removeEventListener: <K extends keyof RedirectHandlerEventMap | string>(type: K, listener: TypedEventListener<RedirectHandler, K extends keyof RedirectHandlerEventMap ? RedirectHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
}
export declare type RedirectEvent = CustomEvent<{
    url: string;
    isHardRedirect: boolean;
    setHardRedirect: (value: boolean) => void;
    options: Options;
}>;
interface RedirectHandlerEventMap {
    redirect: RedirectEvent;
}
export {};
