import { Naja, Options } from '../Naja';
import { HistoryState } from './HistoryHandler';
import { SnippetHandler } from './SnippetHandler';
import { TypedEventListener } from '../utils';
declare module '../Naja' {
    interface Options {
        snippetCache?: boolean | SnippetCacheStorageType;
    }
}
declare module './HistoryHandler' {
    interface HistoryState {
        snippets?: {
            readonly storage: SnippetCacheStorageType;
            readonly key: SnippetCacheKey;
        };
    }
}
export declare class SnippetCache extends EventTarget {
    private readonly naja;
    private readonly storages;
    constructor(naja: Naja);
    private resolveStorage;
    private configureCache;
    private buildHistoryState;
    private restoreHistoryState;
    addEventListener: <K extends keyof SnippetCacheEventMap | string>(type: K, listener: TypedEventListener<SnippetHandler, K extends keyof SnippetCacheEventMap ? SnippetCacheEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
    removeEventListener: <K extends keyof SnippetCacheEventMap | string>(type: K, listener: TypedEventListener<SnippetHandler, K extends keyof SnippetCacheEventMap ? SnippetCacheEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
}
export declare type StoreEvent = CustomEvent<{
    snippets: CachedSnippets;
    state: HistoryState;
    options: Options;
}>;
export declare type FetchEvent = CustomEvent<{
    state: HistoryState;
    options: Options;
}>;
export declare type RestoreEvent = CustomEvent<{
    snippets: CachedSnippets;
    state: HistoryState;
    options: Options;
}>;
interface SnippetCacheEventMap {
    store: StoreEvent;
    fetch: FetchEvent;
    restore: RestoreEvent;
}
declare type CachedSnippets = Record<string, string>;
declare type SnippetCacheKey = CachedSnippets | string | null;
declare type SnippetCacheStorageType = 'off' | 'history' | 'session';
export {};
