import { Naja, Options } from '../Naja';
import { TypedEventListener } from '../utils';
declare module '../Naja' {
    interface Payload {
        snippets?: Record<string, string>;
    }
}
declare type SnippetUpdateOperation = (snippet: Element, content: string) => void;
export declare class SnippetHandler extends EventTarget {
    private readonly naja;
    readonly op: Record<'replace' | 'prepend' | 'append', SnippetUpdateOperation>;
    constructor(naja: Naja);
    static findSnippets(predicate?: (snippet: Element) => boolean): Record<string, string>;
    updateSnippets(snippets: Record<string, string>, fromCache?: boolean, options?: Options): void;
    updateSnippet(snippet: HTMLElement, content: string, fromCache: boolean, options: Options): void;
    addEventListener: <K extends keyof SnippetHandlerEventMap | string>(type: K, listener: TypedEventListener<SnippetHandler, K extends keyof SnippetHandlerEventMap ? SnippetHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
    removeEventListener: <K extends keyof SnippetHandlerEventMap | string>(type: K, listener: TypedEventListener<SnippetHandler, K extends keyof SnippetHandlerEventMap ? SnippetHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
}
export declare type BeforeUpdateEvent = CustomEvent<{
    snippet: Element;
    content: string;
    fromCache: boolean;
    operation: SnippetUpdateOperation;
    changeOperation: (value: SnippetUpdateOperation) => void;
    options: Options;
}>;
export declare type AfterUpdateEvent = CustomEvent<{
    snippet: Element;
    content: string;
    fromCache: boolean;
    operation: SnippetUpdateOperation;
    options: Options;
}>;
interface SnippetHandlerEventMap {
    beforeUpdate: BeforeUpdateEvent;
    afterUpdate: AfterUpdateEvent;
}
export {};
