import { Naja, Options, Payload } from '../Naja';
import { TypedEventListener } from '../utils';
export declare class UIHandler extends EventTarget {
    private readonly naja;
    selector: string;
    allowedOrigins: (string | URL)[];
    private handler;
    constructor(naja: Naja);
    private initialize;
    bindUI(element: Element): void;
    private handleUI;
    clickElement(element: HTMLElement, options?: Options, event?: MouseEvent): Promise<Payload>;
    submitForm(form: HTMLFormElement, options?: Options, event?: Event): Promise<Payload>;
    isUrlAllowed(url: string): boolean;
    addEventListener: <K extends keyof UIHandlerEventMap | string>(type: K, listener: TypedEventListener<UIHandler, K extends keyof UIHandlerEventMap ? UIHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
    removeEventListener: <K extends keyof UIHandlerEventMap | string>(type: K, listener: TypedEventListener<UIHandler, K extends keyof UIHandlerEventMap ? UIHandlerEventMap[K] : CustomEvent>, options?: boolean | AddEventListenerOptions) => void;
}
export declare type InteractionEvent = CustomEvent<{
    element: Element;
    originalEvent?: Event;
    options: Options;
}>;
interface UIHandlerEventMap {
    interaction: InteractionEvent;
}
export {};
