/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Address;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkResponseCache;
import com.squareup.okhttp.ResponseSource;
import com.squareup.okhttp.TunnelRequest;
import com.squareup.okhttp.internal.Dns;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Policy;
import com.squareup.okhttp.internal.http.RawHeaders;
import com.squareup.okhttp.internal.http.RequestHeaders;
import com.squareup.okhttp.internal.http.ResponseHeaders;
import com.squareup.okhttp.internal.http.RetryableOutputStream;
import com.squareup.okhttp.internal.http.RouteSelector;
import com.squareup.okhttp.internal.http.Transport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpEngine {
    private static final CacheResponse GATEWAY_TIMEOUT_RESPONSE = new CacheResponse(){

        @Override
        public Map<String, List<String>> getHeaders() throws IOException {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            result.put(null, Collections.singletonList("HTTP/1.1 504 Gateway Timeout"));
            return result;
        }

        @Override
        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(Util.EMPTY_BYTE_ARRAY);
        }
    };
    public static final int HTTP_CONTINUE = 100;
    protected final Policy policy;
    protected final OkHttpClient client;
    protected final String method;
    private ResponseSource responseSource;
    protected Connection connection;
    protected RouteSelector routeSelector;
    private OutputStream requestBodyOut;
    private Transport transport;
    private InputStream responseTransferIn;
    private InputStream responseBodyIn;
    private CacheResponse cacheResponse;
    private CacheRequest cacheRequest;
    long sentRequestMillis = -1L;
    boolean connected;
    private boolean transparentGzip;
    final URI uri;
    final RequestHeaders requestHeaders;
    ResponseHeaders responseHeaders;
    private ResponseHeaders cachedResponseHeaders;
    private InputStream cachedResponseBody;
    private boolean automaticallyReleaseConnectionToPool;
    private boolean connectionReleased;

    public HttpEngine(OkHttpClient client, Policy policy, String method, RawHeaders requestHeaders, Connection connection, RetryableOutputStream requestBodyOut) throws IOException {
        this.client = client;
        this.policy = policy;
        this.method = method;
        this.connection = connection;
        this.requestBodyOut = requestBodyOut;
        try {
            this.uri = Platform.get().toUriLenient(policy.getURL());
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        this.requestHeaders = new RequestHeaders(this.uri, new RawHeaders(requestHeaders));
    }

    public URI getUri() {
        return this.uri;
    }

    public final void sendRequest() throws IOException {
        if (this.responseSource != null) {
            return;
        }
        this.prepareRawRequestHeaders();
        this.initResponseSource();
        OkResponseCache responseCache = this.client.getOkResponseCache();
        if (responseCache != null) {
            responseCache.trackResponse(this.responseSource);
        }
        if (this.requestHeaders.isOnlyIfCached() && this.responseSource.requiresConnection()) {
            if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
                Util.closeQuietly(this.cachedResponseBody);
            }
            this.responseSource = ResponseSource.CACHE;
            this.cacheResponse = GATEWAY_TIMEOUT_RESPONSE;
            RawHeaders rawResponseHeaders = RawHeaders.fromMultimap(this.cacheResponse.getHeaders(), true);
            this.setResponse(new ResponseHeaders(this.uri, rawResponseHeaders), this.cacheResponse.getBody());
        }
        if (this.responseSource.requiresConnection()) {
            this.sendSocketRequest();
        } else if (this.connection != null) {
            this.client.getConnectionPool().recycle(this.connection);
            this.connection = null;
        }
    }

    private void initResponseSource() throws IOException {
        this.responseSource = ResponseSource.NETWORK;
        if (!this.policy.getUseCaches()) {
            return;
        }
        OkResponseCache responseCache = this.client.getOkResponseCache();
        if (responseCache == null) {
            return;
        }
        CacheResponse candidate = responseCache.get(this.uri, this.method, this.requestHeaders.getHeaders().toMultimap(false));
        if (candidate == null) {
            return;
        }
        Map<String, List<String>> responseHeadersMap = candidate.getHeaders();
        this.cachedResponseBody = candidate.getBody();
        if (!this.acceptCacheResponseType(candidate) || responseHeadersMap == null || this.cachedResponseBody == null) {
            Util.closeQuietly(this.cachedResponseBody);
            return;
        }
        RawHeaders rawResponseHeaders = RawHeaders.fromMultimap(responseHeadersMap, true);
        this.cachedResponseHeaders = new ResponseHeaders(this.uri, rawResponseHeaders);
        long now = System.currentTimeMillis();
        this.responseSource = this.cachedResponseHeaders.chooseResponseSource(now, this.requestHeaders);
        if (this.responseSource == ResponseSource.CACHE) {
            this.cacheResponse = candidate;
            this.setResponse(this.cachedResponseHeaders, this.cachedResponseBody);
        } else if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
            this.cacheResponse = candidate;
        } else if (this.responseSource == ResponseSource.NETWORK) {
            Util.closeQuietly(this.cachedResponseBody);
        } else {
            throw new AssertionError();
        }
    }

    private void sendSocketRequest() throws IOException {
        if (this.connection == null) {
            this.connect();
        }
        if (this.transport != null) {
            throw new IllegalStateException();
        }
        this.transport = (Transport)this.connection.newTransport(this);
        if (this.hasRequestBody() && this.requestBodyOut == null) {
            this.requestBodyOut = this.transport.createRequestBody();
        }
    }

    protected final void connect() throws IOException {
        if (this.connection != null) {
            return;
        }
        if (this.routeSelector == null) {
            String uriHost = this.uri.getHost();
            if (uriHost == null) {
                throw new UnknownHostException(this.uri.toString());
            }
            SSLSocketFactory sslSocketFactory = null;
            HostnameVerifier hostnameVerifier = null;
            if (this.uri.getScheme().equalsIgnoreCase("https")) {
                sslSocketFactory = this.client.getSslSocketFactory();
                hostnameVerifier = this.client.getHostnameVerifier();
            }
            Address address = new Address(uriHost, Util.getEffectivePort(this.uri), sslSocketFactory, hostnameVerifier, this.client.getAuthenticator(), this.client.getProxy(), this.client.getTransports());
            this.routeSelector = new RouteSelector(address, this.uri, this.client.getProxySelector(), this.client.getConnectionPool(), Dns.DEFAULT, this.client.getRoutesDatabase());
        }
        this.connection = this.routeSelector.next(this.method);
        if (!this.connection.isConnected()) {
            this.connection.connect(this.client.getConnectTimeout(), this.client.getReadTimeout(), this.getTunnelConfig());
            this.client.getConnectionPool().maybeShare(this.connection);
            this.client.getRoutesDatabase().connected(this.connection.getRoute());
        } else if (!this.connection.isSpdy()) {
            this.connection.updateReadTimeout(this.client.getReadTimeout());
        }
        this.connected(this.connection);
        if (this.connection.getRoute().getProxy() != this.client.getProxy()) {
            this.requestHeaders.getHeaders().setRequestLine(this.getRequestLine());
        }
    }

    protected void connected(Connection connection) {
        this.policy.setSelectedProxy(connection.getRoute().getProxy());
        this.connected = true;
    }

    public void writingRequestHeaders() {
        if (this.sentRequestMillis != -1L) {
            throw new IllegalStateException();
        }
        this.sentRequestMillis = System.currentTimeMillis();
    }

    private void setResponse(ResponseHeaders headers, InputStream body) throws IOException {
        if (this.responseBodyIn != null) {
            throw new IllegalStateException();
        }
        this.responseHeaders = headers;
        if (body != null) {
            this.initContentStream(body);
        }
    }

    boolean hasRequestBody() {
        return this.method.equals("POST") || this.method.equals("PUT") || this.method.equals("PATCH");
    }

    public final OutputStream getRequestBody() {
        if (this.responseSource == null) {
            throw new IllegalStateException();
        }
        return this.requestBodyOut;
    }

    public final boolean hasResponse() {
        return this.responseHeaders != null;
    }

    public final RequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public final ResponseHeaders getResponseHeaders() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.responseHeaders;
    }

    public final int getResponseCode() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.responseHeaders.getHeaders().getResponseCode();
    }

    public final InputStream getResponseBody() {
        if (this.responseHeaders == null) {
            throw new IllegalStateException();
        }
        return this.responseBodyIn;
    }

    public final CacheResponse getCacheResponse() {
        return this.cacheResponse;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    protected boolean acceptCacheResponseType(CacheResponse cacheResponse) {
        return true;
    }

    private void maybeCache() throws IOException {
        if (!this.policy.getUseCaches()) {
            return;
        }
        OkResponseCache responseCache = this.client.getOkResponseCache();
        if (responseCache == null) {
            return;
        }
        HttpURLConnection connectionToCache = this.policy.getHttpConnectionToCache();
        if (!this.responseHeaders.isCacheable(this.requestHeaders)) {
            responseCache.maybeRemove(connectionToCache.getRequestMethod(), this.uri);
            return;
        }
        this.cacheRequest = responseCache.put(this.uri, connectionToCache);
    }

    public final void automaticallyReleaseConnectionToPool() {
        this.automaticallyReleaseConnectionToPool = true;
        if (this.connection != null && this.connectionReleased) {
            this.client.getConnectionPool().recycle(this.connection);
            this.connection = null;
        }
    }

    public final void release(boolean streamCanceled) {
        if (this.responseBodyIn == this.cachedResponseBody) {
            Util.closeQuietly(this.responseBodyIn);
        }
        if (!this.connectionReleased && this.connection != null) {
            this.connectionReleased = true;
            if (this.transport == null || !this.transport.makeReusable(streamCanceled, this.requestBodyOut, this.responseTransferIn)) {
                Util.closeQuietly(this.connection);
                this.connection = null;
            } else if (this.automaticallyReleaseConnectionToPool) {
                this.client.getConnectionPool().recycle(this.connection);
                this.connection = null;
            }
        }
    }

    private void initContentStream(InputStream transferStream) throws IOException {
        this.responseTransferIn = transferStream;
        if (this.transparentGzip && this.responseHeaders.isContentEncodingGzip()) {
            this.responseHeaders.stripContentEncoding();
            this.responseHeaders.stripContentLength();
            this.responseBodyIn = new GZIPInputStream(transferStream);
        } else {
            this.responseBodyIn = transferStream;
        }
    }

    public final boolean hasResponseBody() {
        int responseCode = this.responseHeaders.getHeaders().getResponseCode();
        if (this.method.equals("HEAD")) {
            return false;
        }
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return this.responseHeaders.getContentLength() != -1L || this.responseHeaders.isChunked();
    }

    private void prepareRawRequestHeaders() throws IOException {
        CookieHandler cookieHandler;
        long ifModifiedSince;
        this.requestHeaders.getHeaders().setRequestLine(this.getRequestLine());
        if (this.requestHeaders.getUserAgent() == null) {
            this.requestHeaders.setUserAgent(HttpEngine.getDefaultUserAgent());
        }
        if (this.requestHeaders.getHost() == null) {
            this.requestHeaders.setHost(HttpEngine.getOriginAddress(this.policy.getURL()));
        }
        if ((this.connection == null || this.connection.getHttpMinorVersion() != 0) && this.requestHeaders.getConnection() == null) {
            this.requestHeaders.setConnection("Keep-Alive");
        }
        if (this.requestHeaders.getAcceptEncoding() == null) {
            this.transparentGzip = true;
            this.requestHeaders.setAcceptEncoding("gzip");
        }
        if (this.hasRequestBody() && this.requestHeaders.getContentType() == null) {
            this.requestHeaders.setContentType("application/x-www-form-urlencoded");
        }
        if ((ifModifiedSince = this.policy.getIfModifiedSince()) != 0L) {
            this.requestHeaders.setIfModifiedSince(new Date(ifModifiedSince));
        }
        if ((cookieHandler = this.client.getCookieHandler()) != null) {
            this.requestHeaders.addCookies(cookieHandler.get(this.uri, this.requestHeaders.getHeaders().toMultimap(false)));
        }
    }

    String getRequestLine() {
        String protocol = this.connection == null || this.connection.getHttpMinorVersion() != 0 ? "HTTP/1.1" : "HTTP/1.0";
        return this.method + " " + this.requestString() + " " + protocol;
    }

    private String requestString() {
        URL url = this.policy.getURL();
        if (this.includeAuthorityInRequestLine()) {
            return url.toString();
        }
        return HttpEngine.requestPath(url);
    }

    public static String requestPath(URL url) {
        String fileOnly = url.getFile();
        if (fileOnly == null) {
            return "/";
        }
        if (!fileOnly.startsWith("/")) {
            return "/" + fileOnly;
        }
        return fileOnly;
    }

    protected boolean includeAuthorityInRequestLine() {
        return this.connection == null ? this.policy.usingProxy() : this.connection.getRoute().getProxy().type() == Proxy.Type.HTTP;
    }

    public static String getDefaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    public static String getOriginAddress(URL url) {
        int port = url.getPort();
        String result = url.getHost();
        if (port > 0 && port != Util.getDefaultPort(url.getProtocol())) {
            result = result + ":" + port;
        }
        return result;
    }

    public final void readResponse() throws IOException {
        if (this.hasResponse()) {
            this.responseHeaders.setResponseSource(this.responseSource);
            return;
        }
        if (this.responseSource == null) {
            throw new IllegalStateException("readResponse() without sendRequest()");
        }
        if (!this.responseSource.requiresConnection()) {
            return;
        }
        if (this.sentRequestMillis == -1L) {
            if (this.requestBodyOut instanceof RetryableOutputStream) {
                int contentLength = ((RetryableOutputStream)this.requestBodyOut).contentLength();
                this.requestHeaders.setContentLength(contentLength);
            }
            this.transport.writeRequestHeaders();
        }
        if (this.requestBodyOut != null) {
            this.requestBodyOut.close();
            if (this.requestBodyOut instanceof RetryableOutputStream) {
                this.transport.writeRequestBody((RetryableOutputStream)this.requestBodyOut);
            }
        }
        this.transport.flushRequest();
        this.responseHeaders = this.transport.readResponseHeaders();
        this.responseHeaders.setLocalTimestamps(this.sentRequestMillis, System.currentTimeMillis());
        this.responseHeaders.setResponseSource(this.responseSource);
        if (this.responseSource == ResponseSource.CONDITIONAL_CACHE) {
            if (this.cachedResponseHeaders.validate(this.responseHeaders)) {
                ResponseHeaders combinedHeaders;
                this.release(false);
                this.responseHeaders = combinedHeaders = this.cachedResponseHeaders.combine(this.responseHeaders);
                OkResponseCache responseCache = this.client.getOkResponseCache();
                responseCache.trackConditionalCacheHit();
                responseCache.update(this.cacheResponse, this.policy.getHttpConnectionToCache());
                this.initContentStream(this.cachedResponseBody);
                return;
            }
            Util.closeQuietly(this.cachedResponseBody);
        }
        if (this.hasResponseBody()) {
            this.maybeCache();
        }
        this.initContentStream(this.transport.getTransferStream(this.cacheRequest));
    }

    protected TunnelRequest getTunnelConfig() {
        return null;
    }

    public void receiveHeaders(RawHeaders headers) throws IOException {
        CookieHandler cookieHandler = this.client.getCookieHandler();
        if (cookieHandler != null) {
            cookieHandler.put(this.uri, headers.toMultimap(true));
        }
    }
}

