document.addEventListener('DOMContentLoaded', function () {

    function renderSetTimer() {
        chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
            $('#close-button').click(function(event) {
                event.preventDefault();
                window.close();
            });

            var tab;
            if (tabs instanceof Array) {
                if (tabs.length == 0) {
                    return;
                }
                tab = tabs[0];
            } else {
                tab = tabs;
            }

            function renderSetTimerTpl(data) {
                var template = $('#set-timer-tpl').html();
                $('.set-timer-container').html(Mustache.render(template, data));

                var updateTimeInput = function($el, timeoutInMinutes) {
                    var now = new Date();
                    $el[0].valueAsNumber = Math.floor((now.getTime() + (timeoutInMinutes - now.getTimezoneOffset()) * 60 * 1000) / 60000) * 60000;
                };

                var updateField = function($a, $b) {
                    var currentValue = $b.val();
                    var newValue = $a.val();
                    if (newValue != currentValue) {
                        $b.val(newValue);
                    }
                };

                $('#timer-timeout')
                    .on('input', function() {
                        updateField($('#timer-timeout'), $('#timer-timeout-range'));
                        updateTimeInput($('#timer-timeout-time'), $(this).val());
                    })
                    .on('keydown', function(event) {
                        if (event.keyCode === 189 || event.keyCode === 190) {
                            event.preventDefault();
                        }
                    })
                    .trigger('input');

                $('#timer-timeout-range').on('input', function() {
                    updateField($('#timer-timeout-range'), $('#timer-timeout'));
                    updateTimeInput($('#timer-timeout-time'), $(this).val());
                });

                $('#timer-timeout-time').on('change input', function() {
                    if (!this.value) {
                        return;
                    }
                    var now = new Date();
                    var val = this.valueAsNumber + new Date(now.getFullYear(), now.getMonth(), now.getDate()).getTime();
                    var timeoutInMinutes = Math.floor((val - now.getTime()) / 60000);
                    if (timeoutInMinutes < 0) {
                        timeoutInMinutes += 24 * 60;
                    }
                    $('#timer-timeout, #timer-timeout-range').val(timeoutInMinutes);
                });

                $('#timer-cancel').click(function(event) {
                    event.preventDefault();
                    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
                        if (tabs.length == 0) {
                            return;
                        }
                        var tab = tabs[0];
                        KTimer.getTimer(tab, function(timer) {
                            if (!timer) {
                                return;
                            }

                            KTimer.removeTimer(tab, function() {
                                chrome.browserAction.setBadgeText({text: '', tabId: tab.id});

                                $('#timer-cancel').hide();
                                $('#timer-submit').show();
                                $('#timer-timeout, #timer-timeout-range, #timer-timeout-time').prop('disabled', false);
                            });
                        });
                    });

                });

                $('#timer-form').submit(function(event) {
                    event.preventDefault();
                    var theWindow = window;
                    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
                        if (tabs.length == 0) {
                            return;
                        }
                        var tab = tabs[0];
                        var timeout = parseInt($('#timer-timeout').val());
                        KTimer.addTimer(tab, timeout, function() {
                            theWindow.close();
                        });
                    });
                });
            }

            KTimer.getTimer(tab, function(timer) {
                var data = {
                    elapsedMinutes: 15,
                    isSet: false
                };

                if (!timer) {
                    renderSetTimerTpl(data);
                    return;
                }

                data.isSet = true;
                data.elapsedMinutes = timer.remainsMinutes();

                $('#timer-cancel').show();
                $('#timer-submit').hide();

                renderSetTimerTpl(data);

            });
        });
    }

    $('a[aria-controls="setTimer"]').on('show.bs.tab', function (e) {
        renderSetTimer();
    });

    $('a[aria-controls="activeTimers"]').on('show.bs.tab', function (e) {
        renderTimersList();
    });

    function renderTimersList() {
        KTimer.getAll(function(timers) {
            var template = $('#timers-list-tpl').html();
            var timersList = Object
                .keys(timers)
                .map(function (key) {
                    var timer = timers[key];
                    return {
                        tabId: timer.tab.id,
                        title: truncate(timer.tab.title, 30, '...'),
                        favIconUrl: timer.tab.favIconUrl,
                        expireAt: moment(timer.expireTime).format('LT'),
                        remainsMinutes: timer.remainsMinutes(),
                        remains: moment(new Date()).to(timer.expireTime)
                    }
                });
            var data = { timers: timersList, hasTimers: timersList.length > 0};
            $('.timers-list-container').html(Mustache.render(template, data));
        });
    }

    $('body').on('click', 'a[data-tab-link]', function(event) {
        event.preventDefault();

        var id = +$(this).attr('data-tab-link');
        chrome.tabs.update(id, {active: true}, function() {
            if (chrome.runtime.lastError) {
                alert(chrome.runtime.lastError.message);
            }
        });
    });

    $('body').on('click', 'a[data-timer-cancel]', function(event) {
        event.preventDefault();

        var id = +$(this).attr('data-timer-cancel');
        KTimer.removeTimer(id, function() {
            chrome.browserAction.setBadgeText({text: '', tabId: id});
            renderTimersList();
        })
    });

    renderSetTimer();
});
